cd /home/oliver/Forschung/OutsideOption/data
clear
set memory 64M
set linesize 255
set scheme s2mono
set linesize 255
global types globals session subjects summary bids final_bids
global types globals session subjects summary sbj
global files 031210LP 031210NH 031210P2
global files $files 031211JJ 031211LP 031211NM 031211PI 031211RL
global files $files 031212K2 031212LM 031212NL 031212P6 031212QQ
global files $files 040517LK 040517QI
global files $files 040518JJ 040518LH 040518P7 040518R0
global files $files 040519JS 040519LQ 040519P6 040519QT
global files $files 040602NF 040602PB
global files $files 041129JN 041129OO
global files $files 041130K1 041130P9 041130R0
global files $files 041201NE 041201P8
global files $files 050207K6
global files $files 050209NE  050209PF
global files $files 050414I7 050414JS 050414MI 050414PR
global files $files 050415I9 050415KF
global files $files 050511K5  050511O7
global files $files 050512IA  050512M9
* Risk:
global files $files 050613HT 050613JN 050613NT
global files $files 050614K0 050614I2 050614O0
global files $files 050615I4 050615O2 050615K0
global files $files 050616I6 050616NT 050616JI

******************** sinput ********************
capture program drop sinput
program define sinput
syntax ,raw(string) files(string)
!mkdir `raw'/sinput
foreach file in `files' {
  !mv `raw'/`file'/`file'* `raw'/split/
  !grep -v "^Subject" `raw'/split/`file'.pay | grep -v "^Experiment" > `raw'/sinput/`file'.pay
}
   capture insheet using "`raw'/sinput/`file'_trans_sbj.xls",names
   cd `raw'/split
   !ls
   !for fname in *.xls;do echo -n "\$fname .";grep -v "\*\*\*\*\*" "\$fname" > "../sinput/\$fname";done
   cd /home/oliver/Forschung/OutsideOption/data
end

******************** stfile ********************
capture program drop stfile
program define stfile
   while ("`1'"!="") {
     clear
     display "splitting `1'"
     splittables raw2/`1'/`1'.xls
     macro shift
   }
end

******************** collect1 ********************
capture program drop collect1
program define collect1
foreach type in $types {
  capture clear
  display "`type'"
  foreach file in $files {
    local fname="raw2/`file'/`file'_`type'"
    if (_N==0) use `fname',clear
    else qui append using `fname'
    capture sort SessionID Treatment Period
    capture sort SessionID Treatment Subject
    compress
  }
  qui save raw2/`type',replace
}
end
******************** collect2 ********************
capture program drop collect2
program define collect2
clear
set memory 32M
use raw2/subjects.dta,clear
sort SessionID Treatment Period
qui merge SessionID Treatment Period using raw2/globals.dta,uniqusing nouniqmaster _merge(mergeglobals)
sort SessionID Treatment Subject
qui merge SessionID Treatment Subject using raw2/session.dta,uniqusing _merge(mergesession)
end

******************** data1 ********************
capture program drop data1
program define data1
  syntax,files(string) types(string) raw(string)
  foreach file in `files' {
      display "`file'"
      capture insheet using "`raw'/sinput/`file'.pay",tab names
      if (_rc==0) {
         save "`raw'/sinput/`file'_pay",replace
      }
      capture insheet using "`raw'/sinput/`file'_trans_sbj.xls",tab names
      if (_rc==0) {
         save "`raw'/sinput/`file'_trans_sbj",replace
      }
      foreach type in `types' {
          foreach num of numlist 1/5 {
*     !ls -la "`raw'/sinput/`file'_`num'_`type'.xls"
          clear
          capture insheet using "`raw'/sinput/`file'_`num'_`type'.xls",tab names
          if (_rc==0) {
            capture drop if sessionid=="SessionID"
            capture drop time*
            capture drop zufall*
            capture drop m_zufall*
            capture drop autowert
            capture drop i
            capture drop tmp_game
            capture drop tmp_max
            save "`raw'/sinput/`file'_`num'_`type'",replace
          }
       }
   }
}
clear
set obs 1
gen dropme=1
foreach file in `files' {
  capture append using "`raw'/sinput/`file'_pay"
}
drop if dropme==1
drop dropme
save payments,replace
end

******************** data2 ********************
capture program drop data2
program define data2
syntax,files(string) types(string) remarks(string) raw(string)
clear
set obs 1
gen dropme=1
foreach file in `files' {
    display "`file'" _continue
    foreach num of numlist 1/5 {
      display "[`num']" _continue
      qui save tmp,replace
      capture use "`raw'/sinput/`file'_`num'_globals",clear
      if (! _rc) {
        qui destring,replace
        compress
        sort sessionid treatmentnumber period
        save "`raw'/sinput/`file'_`num'_globals",replace
        use "`raw'/sinput/`file'_`num'_subjects",clear
        qui destring,replace
        display "`raw'/sinput/`file'_`num'_subjects"
        sort sessionid treatmentnumber period
        merge sessionid treatmentnumber period using "`raw'/sinput/`file'_`num'_globals",uniqusing
        append using tmp
        display "`raw'/sinput/`file'_`num'_subjects / globals"
        }
      }
     display
  }
drop if dropme==1
aorder
capture drop v32-v77
capture drop unerlaubt*
capture drop negb*
capture drop quit_inputstage
capture drop questionnaire 
capture drop v
capture drop low high b_low b_high slope intercept testwert
capture drop m_subject
drop subjects
foreach antwort in 1a 1b 1c 2a 2b 3 4 5 6 7 8 {
  capture label variable a`antwort' "Kontrollantwort `antwort'"
  if (! _rc) {
    label variable correct`antwort' "Antwort `antwort' stimmt"
    recode correct`antwort' 2=0
  }
}
foreach bid of numlist 50(10)100 {
  capture label variable bid_`bid' "Bietfunktion fuer `bid'"
}
foreach bid of numlist 0(10)50 {
  capture label variable bid_x`bid' "Bietfunktion fuer x+`bid'"
  capture label variable exp_x`bid' "Erwartete bietfunktion fuer x+`bid'"
  capture label variable exp_loss_x`bid' "Fehler der Erwartung fuer x+`bid'"
}
foreach auc of numlist 1/5 {
  label variable w`auc' "Gewinner der Auktion `auc'"
  label variable v`auc' "Wert in  Auktion `auc'"
  label variable b`auc' "Gebot in Auktion `auc'"
  label variable p`auc' "Profit in Auktion `auc'"
  label variable m_b`auc' "Mitbietergebot in Auktion `auc'"
}
capture gen oo=.
label variable oo "Outside Option"
capture label variable m_oo "Mitbieter Outside Option"
gen pilot=(sessionid<"031211")
label variable pilot "is a pilot experiment"
gen minutes=60*index("ABCDEFGHIJKLMNOPQRSTUVWX",substr(session,7,1))+index("0123456789ABCDEFGHIJKLMNOPQRSTUVWX",substr(session,8,1))*2-21
gen date="20"+substr(session,1,6)+"-"+string(floor(minutes/60),"%02.0f")+":"+string(mod(minutes,60),"%02.0f")
gen str64 remarks="";
run `remarks'
gen hiwi=(index(remarks,"hiwi"))
label variable hiwi "VP ist Hilfskraft"
*
recode treatmentnumber 2=3 if pilot
recode treatmentnumber (1=2) (2=1) if sessionid=="031211RL"
* In dieser Session
*haben wir Kontrollfragen und Info-Screen genau umgekehrt gespielt als
*sonst. Philipp hatte es umgekehrt angekndigt, also blieb Eva nicht viel
*anderes brig als umgekehrt zu starten.
*
label define treattype 1 "Kontrollfragen" 2 "Conversion Rate" 3 "Bieten" 4 "Questionnaire"
label values treatmentnumber treattype
*
capture gen treatment_type=.
rename treatment_type sessiontype
label define sessionlabel 1 "A no outside option" 2 "B opp. has equal oo" 3 "C opp. has random oo" 4 "B' changing oo"
label values sessiontype sessionlabel
recode sessiontype 2=4 if sessionid=="031212LM"
label variable sessiontype "Type of session"
tab sessionid sessiontype
*
label define proglabel 1 "one stage, input mixed up" 2 "many stages, slightly unstable" 3 "fewer stages, stable"
gen progtype=2
qui replace progtype=1 if pilot
qui replace progtype=3 if sessionid>="031212"
label values progtype proglabel
label variable progtype "Version du logiciel"
*
gen showupfee=0
label variable showupfee "Show up fee in ECU"
qui replace showupfee=75 if sessiontype==1 & !pilot
qui replace totalprofit=totalprofit-75 if sessionid=="031212K2"
label variable totalprofit "Total profit exclusive show up fee"
*gen convrate=sessiontype
*label variable convrate "Euro/ECU"
*recode convrate (1=25) (2=120) (3=150) (4=130)
*qui replace convrate=1/convrate
*qui replace convrate=. if pilot
drop if dropme==1
drop dropme
drop participate
drop if missing(subject)
sort sessionid subject
drop _merge
save auctmp,replace
end

******************** data3 *********************
* (this is no longer used since 2004-12)
capture program drop data3
program define data3
   syntax ,files(string) date(string) raw(string)
clear
set obs 1
gen dropme=1
foreach file in `files' {
    display "`file'"
    capture append using "`raw'/sinput/`file'_trans_sbj"
        if (! _rc) {
          display "`raw'/sinput/`file'_trans_sbj"
        }
  }
drop if dropme
rename session sessionid
capture rename male female
* the following is done always - in the experiments
* where the female variable was present it was
* not coded correctly, in the experiments were the
* make variable was present we have to recode anyhow:
recode female (1=0) (0=1)
label define fm 0 "male" 1 "female"
label values female fm
label variable female "Geschlecht"
label variable age "Alter"
label variable client "Rechner"
desc
tab complicated female
tab studiengang
qui replace studiengang=lower(studiengang)
gen str32 fach=studiengang
qui replace fach="wiwi" if index(studiengang,"bwl") | index(studiengang,"vwl") | index(studiengang,"betriebs") | index(studiengang,"volksw") | index(studiengang,"wirtsch") | index(studiengang,"wifo") 
qui replace fach="jura" if index(studiengang,"jura") | index(studiengang,"rechts") 
qui replace fach="naturw" if index(studiengang,"info") | index(studiengang,"software") | fach=="ti" | index(studiengang,"masch") | index(studiengang,"mathe") 
qui replace fach="sowi" if index(studiengang,"sowi") | index(studiengang,"psych")  | index(studiengang,"sozial") | index(studiengang,"erzie") 
qui replace fach="sprachen" if index(studiengang,"deutsch") | index(studiengang,"anglis")  | index(studiengang,"german") 
qui replace fach="sonstige" if fach=="lag" | index(studiengang,"politik") 
drop studiengang
label define janein 0 "Nein" 1 "Ja"
encode auction_exp_teilnahme,gen(erfauc) label(janein)
label variable erfauc "haben Sie an Auktionsexp. teilgen."
encode exp_teilnahme,gen(erfexp) label(janein)
label variable erfexp "haben Sie an oekon. Exp. teilgen."
drop exp_teilnahme auction_exp_teilnahme
label variable complicated "0=einfach, 5=kompliziert"
label variable fach "Studienfach"
qui replace age=subinstr(age," Jahre","",.)
destring age,replace
compress
sort sessionid subject
save auction`date'quest,replace
use auction`date'quest,clear
*use auction200405quest,clear
drop strategy
merge sessionid subject using auctmp
* what is the interesting treatment
egen bidtreatment=median(treatmentnumber),by(sessionid)
egen sid=group(sessionid subject)
label variable subject "Subject id in a session"
label variable sid "Subject"
egen lg=min(group) if treatmentnumber==bidtreatment,by(sid)
egen ug=max(group) if treatmentnumber==bidtreatment,by(sid)
gen fit=0
egen mg=max(group),by(sessionid)
gen border=mg+1
qui sum mg
local mg=r(max)
foreach border of numlist 2/`mg' {
  qui replace fit=((lg>`border')+(ug<=`border'))
  capture drop afit
  egen afit=min(fit),by(sessionid)
  qui replace border=`border' if afit==1 & `border'<mg
}
egen mborder=median(border),by(sessionid)
qui replace mg=(lg>mborder) if treatmentnumber==bidtreatment
egen matchgroup=median(mg),by(sid)
label variable matchgroup "zweite Matching Group"
drop lg ug border mborder fit afit mg
egen indepobs=group(sessionid matchgroup)
sort sessionid treatmentnumber period group
capture drop m_oo
gen m_oo=oo[_n+1] if group==group[_n+1]
qui replace m_oo=oo[_n-1] if group==group[_n-1]
label variable m_oo "Mitbieter Outside Option"
foreach try of numlist 1/5 {
   gen m_v`try'=v`try'[_n+1] if group==group[_n+1]
   qui replace m_v`try'=v`try'[_n-1] if group==group[_n-1]
   label variable m_v`try' "Mitbieter Wert in Auktion `try'"
}
aorder
compress
save auction`date',replace
end
************************** data4 ****************************
capture program drop data4
program define data4
*
qui gen pilot=(SessionID<"031211")
label variable pilot "is a pilot experiment"
qui gen magdeburg=(SessionID>"050400")
label variable magdeburg "Session in Magdeburg"
zTreeDate SessionID,gen(date) short(datenew)
gen expect= (exp_x50 < .)
label variable expect "treatment with expectations"
label variable exp_feedback_on "Erwartungsfeedback erfolgt"
replace exp_feedback_on=0 if exp_feedback_on==.
label variable feedback_expbidsoff "keine Bietfunktion des anderen gezeigt"
replace feedback_expbidsoff=0 if feedback_expbidsoff==.
label variable exp_punishing_rate "Strafe fuer abweichende Erwartungen"
qui gen Type=2
qui replace Type=1 if datenew <= d(12dec2003)
qui replace Type=3 if datenew >= d(29nov2004) & datenew<= d(01dec2004)
qui replace Type=4 if datenew >= d(13jun2005) & datenew<= d(16jun2005)
label define Type 1 "FirstPrice" 2 "Overbidding" 3 "SecondPrice" 4 "MultiFeedback"
label values Type Type
label variable Type "Type of Experiment"
qui gen second=(Type==3)
label variable second "Second Price Auction"
recode Treatment 2=3 if pilot
recode Treatment (1=2) (2=1) if SessionID=="031211RL"
* In dieser Session
*haben wir Kontrollfragen und Info-Screen genau umgekehrt gespielt als
*sonst. Philipp hatte es umgekehrt angekndigt, also blieb Eva nicht viel
*anderes brig als umgekehrt zu starten.
label define treattype 1 "Kontrollfragen" 2 "Conversion Rate" 3 "Bieten" 4 "Questionnaire"
label values Treatment treattype
capture gen treatment_type=.
rename treatment_type sessiontype
label define sessionlabel 1 "A no outside option" 2 "B opp. has equal oo" 3 "C opp. has random oo" 4 "B' changing oo"
recode sessiontype 2=4 if SessionID=="031212LM"
qui replace sessiontype=1 if sessiontype==.
egen stype=median(sessiontype),by(SessionID)
label values stype sessionlabel
label variable stype "Type of session"
drop sessiontype
rename stype sessiontype
*
label variable x "minimal valuation"
*
label define proglabel 1 "one stage, input mixed up" 2 "many stages, slightly unstable" 3 "fewer stages, stable"  4 "one stage, ClientDropDetection" 5 "one stage, no DropDetection"
qui gen progtype=2
qui replace progtype=1 if pilot
qui replace progtype=3 if SessionID>="031212"
qui replace progtype = 4 if SessionID=="041129JN" | SessionID=="041129OO"
qui replace progtype = 5 if SessionID=="041130K1" | SessionID=="041130P9" | SessionID=="041130R0"
qui replace progtype = 4 if SessionID=="041201NE" | SessionID=="041201P8"
label values progtype proglabel
label variable progtype "Version du logiciel"
*
egen sid=group(SessionID Subject)
label variable Subject "Subject id in a session"
label variable sid "Subject"
egen bidtreatment=median(Treatment),by(SessionID)
qui replace x=50 if x==. & bidtreatment==Treatment
egen xx=median(x),by(SessionID)
qui replace x=xx if x==.
drop xx
foreach bid of numlist 50(10)100 {
  local xbid=`bid'-50
  capture label variable bid_`bid' "Bietfunktion fuer `bid'"
  capture label variable bid_x`xbid' "Bietfunktion fuer x+`bid'"
  qui replace bid_x`xbid'=bid_`bid' if bid_x`xbid'==. & bidtreatment & x==50
  qui replace bid_`bid'=bid_x`xbid' if (x==50) & (bid_`bid'==.)
}
foreach bid of numlist 0(10)50 {
  label variable exp_x`bid' "Erwartete bietfunktion fuer x+`bid'"
  capture label variable exp_loss_x`bid' "Fehler der Erwartung fuer x+`bid'"
}
aorder
drop v10-v155
drop Time*
drop time*
drop low high b_low b_high slope intercept testwert zufall*
foreach antwort in 1a 1b 1c 2a 2b 3 4 5 6 7 8 {
  capture label variable A`antwort' "Kontrollantwort `antwort'"
  if (! _rc) {
    capture label variable correct`antwort' "Antwort `antwort' stimmt"
    capture recode correct`antwort' 2=0
  }
}
foreach auc of numlist 1/5 {
  label variable w`auc' "Gewinner der Auktion `auc'"
  label variable v`auc' "Wert in  Auktion `auc'"
  label variable b`auc' "Gebot in Auktion `auc'"
  label variable p`auc' "Profit in Auktion `auc'"
  label variable m_b`auc' "Mitbietergebot in Auktion `auc'"
}
label variable oo "Outside Option"
capture label variable m_oo "Mitbieter Outside Option"
*
qui gen str64 remarks="";
qui replace remarks="hiwi patrick" if SessionID=="031210NH" & Subject==5
qui replace remarks="hiwi eric" if SessionID=="031210NH" & Subject==3
qui replace remarks="hiwi" if SessionID=="031211JJ" & Subject==1
qui replace remarks="langsam, viele notizen" if SessionID=="031211JJ" & Subject==10
qui replace remarks="hiwi eric" if SessionID=="031211LP" & Subject==2
qui replace remarks="hiwi volker" if SessionID=="031211PI" & Subject==2
qui replace remarks="bankrott in P1" if SessionID=="031211PI" & Subject==10
qui replace remarks="langsam" if SessionID=="031211PI" & Subject==13
qui replace remarks="langsam" if SessionID=="031211RL" & Subject==11
qui replace remarks="hiwi eric" if SessionID=="031212K2" & Subject==9
qui replace remarks="unabhaengigkeit nicht verstanden in P5" if SessionID=="031212K2" & Subject==1
qui replace remarks="bankrott in P1" if SessionID=="031212K2" & Subject==10
qui replace remarks="bankrott in P2" if SessionID=="031212P6" & Subject==5
qui replace remarks="bankrott in P1" if SessionID=="031212QQ" & Subject==6
qui replace remarks="langsam" if SessionID=="031212QQ" & Subject==18
qui replace remarks="hiwi Vasco" if SessionID=="041129JN" & Subject==14
qui replace remarks="hiwi Sebastian" if SessionID=="041129OO" & Subject==16
qui replace remarks="hiwi Thomas" if SessionID=="041130K1" & Subject==6
qui gen hiwi=(index(remarks,"hiwi"))
label variable hiwi "VP ist Hilfskraft"
*
qui gen showupfee=0
label variable showupfee "Show up fee in ECU"
qui replace showupfee=75 if sessiontype==1 & !pilot & datenew<= d(01dec2004)
qui replace showupfee=0 if SessionID=="041130R0" | SessionID=="041201NE" | SessionID=="041201P8"
qui replace TotalProfit=TotalProfit-75 if SessionID=="031212K2"
label variable TotalProfit "Total profit exclusive show up fee"
*qui gen convrate=sessiontype
*label variable convrate "Euro/ECU"
*recode convrate (1=25) (2=120) (3=150) (4=130)
*qui replace convrate=1/convrate
*qui replace convrate=. if pilot
*qui replace convrate=1/35 if SessionID=="041130R0" | SessionID=="041201NE" | SessionID=="041201P8"
sort SessionID Treatment Period Subject
label variable N "number of subjects"
egen kkurs=median(kurs),by(SessionID)
qui replace kurs=kkurs
qui replace min_eingabe=0 if min_eingabe==. & Treatment==bidtreatment & SessionID<"03XXXX"
drop kkurs
label variable kurs "ECU/Euro"
tempvar swap
foreach var of varlist exp_feedback_on feedback_expbidsoff n_games n_auctions {
  capture drop `swap'
  egen `swap'=median(`var'),by(SessionID)
  replace `var'=`swap'
}
replace feedback_expbidsoff=. if !exp_feedback_on
foreach var of varlist n_games n_auctions {
  replace `var'=1 if `var'==.
}
label variable n_auctions "Number of auctions used for payoff"
label variable n_games "Number of auctions shown in feedback"
label variable date "Date of the experiment"
label variable Group "Group in a session"
drop NRematch1 NRematch2 NinMatchgroup1 NinMatchgroup2 RRank Rematching RepeatTreatment absx b max_item min_item plus* unerlaubt* v verlust*
gen plus=(min_eingabe==0)
label variable b_min "Min. Eingabe - x"
label variable b_max "Max. Eingabe - x - 50"
label variable max_eingabe "Max. Eingabe"
label variable min_eingabe "Min. Eingabe (following instructions)"
label variable plus "Instructions mention positive bids only"
label variable v_max "Maximal value (x+50)"
label variable v_min "Minimal value (x)"
label variable datenew "Date of the experiment"
order Type second SessionID date datenew Subject sid Period Treatment treatmenttype bidtreatment x oo questionnaire sessiontype Matchgroup1 Matchgroup2
compress
end
****************************************
capture program drop dataquest
program define dataquest
order SessionID
destring,replace
qui replace female=male
drop male
* the following is done always - in the experiments
* where the female variable was present it was
* not coded correctly, in the experiments were the
* make variable was present we have to recode anyhow:
tab female
  recode female (1=0) (0=1)
label define fm 0 "male" 1 "female"
label values female fm
label variable female "Geschlecht"
label variable age "Alter"
label variable client "Rechner"
qui replace studiengang=lower(studiengang)
qui gen str32 fach=studiengang
qui replace fach="wiwi" if index(studiengang,"bwl") | index(studiengang,"vwl") | index(studiengang,"betriebs") | index(studiengang,"wipd") | index(studiengang,"volksw") | index(studiengang,"wirtsch") | index(studiengang,"wifo") | index(studiengang,"cdsem") | index(studiengang,"finanz") 
qui replace fach="jura" if index(studiengang,"jura") | index(studiengang,"rechts") 
qui replace fach="naturw" if index(studiengang,"inf") | index(studiengang,"software") | fach=="ti" | index(studiengang,"masch") | index(studiengang,"mathe")  | index(studiengang,"pharm") 
qui replace fach="sowi" if index(studiengang,"sowi") | index(studiengang,"psych")  | index(studiengang,"sozial") | index(studiengang,"erzie") 
qui replace fach="sprachen" if index(studiengang,"deutsch") | index(studiengang,"anglis")  | index(studiengang,"german")  | index(studiengang,"sprach") 
qui replace fach="sonstige" if fach=="lag" | index(fach,"pol")  | index(fach,"philo") | index(fach,"geschi")
qui replace fach="" if index(fach,"keinen") | index(fach,"entf") | index(fach,"sekret") | index(fach,"magister") | index(fach,"dritte")
egen gfach=group(fach)
desc gfach
egen count=count(gfach),by(gfach)
qui replace fach="" if count<3
drop studiengang
label define janein 0 "Nein" 1 "Ja"
encode auction_exp_teilnahme,gen(erfauc) label(janein)
label variable erfauc "haben Sie an Auktionsexp. teilgen."
encode exp_teilnahme,gen(erfexp) label(janein)
label variable erfexp "haben Sie an oekon. Exp. teilgen."
drop exp_teilnahme auction_exp_teilnahme
label variable complicated "0=einfach, 5=kompliziert"
label variable fach "Studienfach"
qui replace age=subinstr(age," Jahre","",.)
destring age,replace
compress
drop gfach count
sort SessionID Subject
end

*************************** data5 ****************************
capture program drop data5
program define data5
egen lg=min(Group) if Treatment==bidtreatment,by(sid)
egen ug=max(Group) if Treatment==bidtreatment,by(sid)
qui gen fit=0
qui egen mg=max(Group)  if Treatment==bidtreatment,by(SessionID)
qui gen border=mg+1
qui sum mg
local mg=r(max)
foreach border of numlist 2/`mg' {
  qui replace fit=((lg>`border')+(ug<=`border'))
  capture drop afit
  qui egen afit=min(fit),by(SessionID)
  qui replace border=`border' if afit==1 & `border'<mg
}
qui egen mborder=median(border),by(SessionID)
qui replace mg=(lg>mborder) if Treatment==bidtreatment
qui egen matchgroup=median(mg),by(sid)
label variable matchgroup "zweite Matching Group"
gen dategrp=date+"-"+string(matchgroup)
drop lg ug border mborder fit afit mg
qui egen indepobs=group(SessionID matchgroup)
sort SessionID Treatment Period Group
capture drop m_oo
qui gen m_oo=oo[_n+1] if Group==Group[_n+1]
qui replace m_oo=oo[_n-1] if Group==Group[_n-1]
label variable m_oo "Mitbieter Outside Option"
foreach try of numlist 1/5 {
   gen m_v`try'=v`try'[_n+1] if Group==Group[_n+1]
   qui replace m_v`try'=v`try'[_n-1] if Group==Group[_n-1]
   label variable m_v`try' "Mitbieter Wert in Auktion `try'"
}
compress
end
*
****************************************
capture program drop regt
program define regt
syntax varlist [if],[Comment(string) onei(integer 0) oneii(integer 0)]
tokenize `varlist'
display "`comment'" _continue
clreg `1' `if',cluster(indepobs) oneside(`onei')
clreg `2' `if',cluster(indepobs) oneside(`oneii') end noshown
end

capture program drop multireg
program define multireg
syntax ,command(string) option(string)
`command' if x==-25,c(-25 & $-$) `option'
`command' if x==0 & !plus,c(0 & $-$) `option'
`command' if x==0 & plus,c(0 & $+$) `option'
`command' if x==25 & !plus,c(25 & $-$) `option'
`command' if x==50 & !plus,c(50 & $-$) `option'
`command' if x==50 & plus,c(50 & $+$) `option'
`command' if !second,c(\multicolumn{2}{l}{all firstprice}) `option'
`command' if second,c(\multicolumn{2}{l}{secondprice}) `option'
end
************************** neTreats ****************************
* 
capture program drop neTreats
program define neTreats
local opt all width(20)
psline `1' `2' if x==-25,`opt' pscommand(`pre'\pslineMXXV)
psline `1' `2' if x==0 & plus,`opt' pscommand(`pre'\pslineZP)
psline `1' `2' if x==0 & !plus,`opt' pscommand(`pre'\pslineZ)
psline `1' `2' if x==25 & !plus,`opt' pscommand(`pre'\pslineXXV)
psline `1' `2' if x==50 & plus & !second,`opt' pscommand(`pre'\pslineLP)
psline `1' `2' if x==50 & !plus & !second,`opt' pscommand(`pre'\pslineL)
psline `1' `2' if x==50 & second,`opt' pscommand(`pre'\pslineSND)
end
*
************************** feTreats ****************************
capture program drop feTreats
program define feTreats,byable(recall)
local opt all width(20)
psline `1' `2' if n_games==1 & n_auctions==1,`opt' pscommand(`pre'\pslineii)
psline `1' `2' if n_games==50 & n_auctions==1,`opt' pscommand(`pre'\pslineLi)
psline `1' `2' if n_games==50 & n_auctions==10,`opt' pscommand(`pre'\pslineLX)
psline `1' `2' if n_games==50 & n_auctions==50,`opt' pscommand(`pre'\pslineLL)
end
************************** namevars ****************************
capture program drop namevars
program define namevars
   syntax varlist
   foreach name of varlist `varlist' {
     capture local newname=substr(`name'[1],1,32)
     if (_rc==0) {
       if ("`newname'"!="") rename `name' `newname'
       else drop `name'
     }
     else  drop `name'
   }
drop if _n==1
end
******************** regc ********************
  capture program drop regc
program define regc,rclass
syntax, var(string) [restrict(string) option(string) label(string) pos(string)]
if ("`pos'"=="") local pos 5
if ("`label'"!="") label variable `var' "`label'"
tempvar cvar
qui gen `cvar'=.
local tw
local li=1
local label
foreach x of numlist -25 0 25 50 {
  foreach plus of numlist 0 1 {
    if (`plus'==0 | `x'==0 | `x'==50) {
      local p="-"
      if (`plus') local p="+"
      local cond if x==`x' & plus==`plus'
      tempvar cumul
      qui cumul `var' `cond',gen(`cumul')
      qui replace `cvar'=`cumul' `cond'
      drop `cumul'
      local tw `tw' (line `cvar' `var' `cond' `restrict',sort(`cvar') c(J))
      local label `label' label(`li' `x'`p')
      local li=`li'+1
    }
  }
}
label variable `cvar' "cumulative distribution"
twoway `tw',legend(`label' ring(0) col(1) pos(`pos')) `option' 
end
**************** mypsline ***************
  capture program drop mypsline
program define mypsline
   syntax varlist [,n(integer 4) Bands(integer 4) noLimits]
   tempname cz
   cumul `3',gen(`cz')
   qui sum `3'
   forvalues b = 1/`bands' {
     qui sum `3' if `cz'>=(`b'-1)/`bands' & `cz'<=`b'/`bands'
     local median=r(mean)
     psline `1' `2' if `cz'>=(`b'-1)/`bands' & `cz'<=`b'/`bands',width(200) n(`n') `limits'
     display "% " round(`median',.1)
   }
end
************************* expGen *******************************************************
capture program drop expGen
program define expGen
* remove outsideoption treatments:
keep if sessiontype==1 & !second
drop if pilot
drop if Treatment != bidtreatment
* expectation treatments all have minimal valuation x=50
keep if x==50
* expectation treatments all have min_eingabe = -50
* keep if min_eingabe==-50
foreach x of numlist 0(10)50 {
  gen over`x'=bid_x`x'-x-`x'/2
  replace over`x'=bid_x`x'-x-`x' if second
  gen eOver`x' = exp_x`x'-x-`x'/2
}
sum over*
sum eOver*
collapse (median) eOver* over*,by(SessionID date matchgroup indepobs expect plus x sid min_eingabe second magdeburg Period feedback_expbidsoff)
egen i=group(sid Period)
reshape long eOver over exp_loss_x,i(i) j(value)
replace feedback_expbidsoff=0 if expect==0
end
